clear
close all
clc
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultLegendInterpreter','latex'); %trying to set the default

%% Control Panel
line_plot = 0;
plot_non_final = 1;
plot_depth_sep = 1;
plot_plane = 0;
delta_max = 5;
z_min = -38;
z_max = 25;
t = 1.5;

%% File reading
fid = fopen('RS_Tilted_32Measurements.txt');
    formatSpec = '%s';
    N = 32*4;
    C_text = textscan(fid,formatSpec,N,'Delimiter','\t');
    C_data0 = textscan(fid,repmat('%f',[1,32*4]),'Delimiter','\t');
fclose(fid);

%% Data processing
index_vec = 1:128;index_vec(1:4:end)=[];index_vec(3:3:end)=[];
Mat_data = [(1:3600)' cell2mat(C_data0(index_vec))]; % N(solo la col 1) Angolo(deg) Valore
% Mat_data = Mat_data(1:5:end,:);

nMeasurements = 32;
r0 = 15.5; % [mm]
rf = 31; % [mm]
deltaR = (rf-r0)/(nMeasurements-1);

nPoints = size(Mat_data,1); % Data points per radius
r_vec = zeros(nPoints*nMeasurements,1);
r_mat = zeros(nPoints,nMeasurements);
z_vec = r_vec;
z_mat = r_mat;
theta_vec = repmat(Mat_data(:,2),nMeasurements,1)*pi/180;
theta_mat = repmat(Mat_data(:,2),1,nMeasurements)*pi/180;

for i =1:nMeasurements
    r_vec((1:nPoints)+nPoints*(i-1)) = r0+deltaR*(i-1);
    r_mat(:,i) = r0+deltaR*(i-1);
    z_vec((1:nPoints)+nPoints*(i-1)) = Mat_data(:,3+2*(i-1));
    z_mat(:,i) = Mat_data(:,3+2*(i-1));
end

%% Plots
X = r_mat.*cos(theta_mat);
Y = r_mat.*sin(theta_mat);
z_mat(z_mat<z_min) = z_min;
z_mat(z_mat>z_max) = z_max;

% [result] = GetGradient(r_mat,theta_mat,z_mat,X,Y);
[cuts,isGroove,~] = FindCuts(X,Y,z_mat,t);
x_groove = X(isGroove(500:1000,1),1);
y_groove = Y(isGroove(500:1000,1),1);
[theta_groove_val,~] = cart2pol(x_groove([1 end]),y_groove([1 end]));
fprintf('Angular value of groove is %.3f°\n',abs(theta_groove_val(end)-theta_groove_val(1))*180/pi)

B = [reshape(X,[],1), reshape(Y,[],1), ones(numel(X),1)]\reshape(z_mat,[],1);
xv = [min(reshape(X,[],1)) max(reshape(X,[],1))];
x_vec = [min(xv) min(xv) max(xv) max(xv)];
X_vec = [min(min(X)) min(min(X)) max(max(X)) max(max(X))];
yv = [min(reshape(Y,[],1)) max(reshape(Y,[],1))];
y_vec = [min(yv) max(yv) max(yv) min(yv)];
Y_vec = [min(min(Y)) max(max(Y)) max(max(Y)) min(min(Y))];
fit_plane_func = @(x,y) B(1).*x+B(2).*y + B(3);

if plot_non_final
figure
hold on
mesh(X,Y,z_mat);
% patch(X_vec,Y_vec,fit_plane_func(X_vec,Y_vec),'r', 'FaceAlpha',0.5)
hold off
colorbar
xlabel('x')
ylabel('y')
view(2)
title('Raw data')
end

pivot = [max(X_vec) max(Y_vec)];pivot = [pivot fit_plane_func(pivot(1),pivot(2))];
delta_z = pivot(3) - fit_plane_func(X,Y);
B = [reshape(X,[],1), reshape(Y,[],1), ones(numel(X),1)]\reshape(z_mat+delta_z,[],1);
z_mat_flat = z_mat+delta_z-pivot(3);
z_non_groove = z_mat_flat(~(cuts|isGroove));
x_non_groove = X(~(cuts|isGroove));
y_non_groove = Y(~(cuts|isGroove));

[xData, yData, zData] = prepareSurfaceData( x_non_groove, y_non_groove, z_non_groove );
ft = fittype( 'poly22' );
opts = fitoptions( 'Method', 'LinearLeastSquares' );
opts.Robust = 'Bisquare';
[fitresult, ~] = fit( [xData, yData], zData, ft, opts );
func_surf_fit = @(x,y) fitresult.p00 + fitresult.p10*x + fitresult.p01*y + fitresult.p20*x.^2 + fitresult.p11*x.*y + fitresult.p02*y.^2;
z_ref = mean(z_non_groove,"all");

delta_z = z_ref - func_surf_fit(X,Y);
z_mat_flat = z_mat_flat + delta_z;%- mean(z_Non_groove,"all");
z_mat_flat = z_mat_flat - mean(z_mat_flat(~(cuts|isGroove)),"all");

[~,~,PadPlane] = FindCuts(X,Y,z_mat_flat,t);

if plot_non_final
figure
mesh(X,Y,z_mat_flat);
colorbar
xlabel('x')
ylabel('y')
title('Non-filtered, flat')
view(2)
end

z_mat_flat = Data_filtering(z_mat_flat,delta_max);
z_mat_flat(z_mat_flat>z_max) = z_max;
z_mat_flat(z_mat_flat<z_min) = z_min;
z_mat_flat(cuts)=NaN;

figure
hold on
mesh(X,Y,z_mat_flat);
colorbar
axis equal
xlabel('x')
ylabel('y')
title('Filtered, flat')
view(2)
alpha_vec = zeros(1,6);
z_in = [];z_mid = []; z_out = [];
for iPad=1:6
    points = PadPlane.(sprintf('pad%d',iPad)).points;
    B =  PadPlane.(sprintf('pad%d',iPad)).plane;
    pos = PadPlane.(sprintf('pad%d',iPad)).pos;
    pad_full = PadPlane.(sprintf('pad%d',iPad)).full;

    X_vec = [X(pos(1),1) X(pos(3),end) X(pos(4),end) X(pos(2),1)];
    Y_vec = [Y(pos(1),1) Y(pos(3),end) Y(pos(4),end) Y(pos(2),1)];
    fit_plane_func = @(x,y) B(1).*x + B(2).*y + B(3);
    center_point = [mean(X_vec) mean(Y_vec) fit_plane_func(mean(X_vec),mean(Y_vec))];
    center_point = center_point/norm(center_point);
    B = B/norm(B);
    radial_alpha = 180-rad2deg(acos((-center_point*B')/(norm(B))));
    fprintf('For pad %d, the radial tilt angle is: %.2f°\n',iPad,radial_alpha)

    alpha = 180-rad2deg(acos(([0 0 1]*B')/(norm(B))));
    alpha_vec(iPad) = alpha;
    fprintf('For pad %d, the tilt angle is: %.2f°\n',iPad,alpha)
    if plot_plane
        patch(X_vec,Y_vec,fit_plane_func(X_vec,Y_vec),'r', 'FaceAlpha',0.5)
    end
    text(X_vec(3)*1.1,Y_vec(3)*1.1,z_max*1.1,sprintf('Pad %d',iPad))

    points_in = pad_full; points_in(:,2:end) = false;
    points_mid = pad_full; points_mid(:,[1:15 17:end]) = false;
    points_out = pad_full; points_out(:,1:end-1) = false;

    z_in = [z_in z_mat_flat(points_in)];
    z_mid = [z_mid z_mat_flat(points_mid)];
    z_out = [z_out z_mat_flat(points_out)];
end
theta_vec_pad_in = repmat((1:size(z_in,1))'*0.1,1,6)*pi/180;
theta_vec_pad_mid = repmat((1:size(z_mid,1))'*0.1,1,6)*pi/180;
theta_vec_pad_out = repmat((1:size(z_out,1))'*0.1,1,6)*pi/180;
theta_vec_pad_out(end-1:end,:)=[];

pos_in = find(~points_in);pos_in = pos_in(1);
z_in(:,end) = [z_in(pos_in:end,end);z_in(1:pos_in-1,end)];

pos_mid = find(~points_mid(:,16));pos_mid = pos_mid(1);
z_mid(:,end) = [z_mid(pos_mid:end,end);z_mid(1:pos_mid-1,end)];

pos_out = find(~points_out(:,end));pos_out = pos_out(1);
z_out(:,end) = [z_out(pos_out:end,end);z_out(1:pos_out-1,end)];


z_out(end-1:end,:)=[];
hold off
alpha_mean = mean(alpha_vec,"all");
fprintf('Mean inclination angle of the pads is %.2f°\n',alpha_mean)

figure
if ~plot_depth_sep
subplot(1,3,1)
end
hold on
for i=1:size(z_in,2)
    plot(theta_vec_pad_in(:,1)*r0,z_in(:,i))
end
title(sprintf('Inner Radius r=%.2f mm',r0))
xlabel('$r\cdot \Delta \theta$ [mm]')
ylabel('z [$\mu m$]')
figureEditor
% plot(mean(z_in,2),'m')
hold off

if plot_depth_sep
    figure
else
    subplot(1,3,2)
end
title(sprintf('Middle Radius r=%.2f mm',r_mat(1,16)))
xlabel('$r\cdot \Delta \theta$ [mm]')
ylabel('z [$\mu m$]')
hold on
for i=1:size(z_in,2)
    plot(theta_vec_pad_mid(:,1)*r_mat(1,16),z_mid(:,i))
end
figureEditor
hold off

if plot_depth_sep
    figure
else
    subplot(1,3,3)
end
title(sprintf('Outer Radius r=%.2f mm',rf))
xlabel('$r\cdot \Delta \theta$ [mm]')
ylabel('z [$\mu m$]')
hold on
for i=1:size(z_in,2)
    plot(theta_vec_pad_out(:,1)*rf,z_out(:,i))
end
figureEditor
hold off

z_mat_flat(z_mat_flat>7) = 7;
figure
hold on
mesh(X,Y,z_mat_flat);
colorbar
axis equal
xlabel('x')
ylabel('y')
title('Surface Scan of Tilted Bearing')
view(2)

for i=1:length(alpha_vec)
fprintf('Pad %d & %.2f \\\\ \\hline\n',i,alpha_vec(i))
end
fprintf('Mean Pad Tilt & %.2f \\\\ \\hline\n',alpha_mean)

%%

z_mean_mat = zeros(size(reshape(X(PadPlane.pad1.full),[],32)));
mean_pad_points = false(size(z_mat_mean));

for iPad = 1:5
    pad_cond = PadPlane.(sprintf('pad%d',iPad)).full;
    pad_full = reshape(z_mat_flat(pad_cond),[],32);
    pad_full(isnan(pad_full)) = z_mean_mat(isnan(pad_full))/iPad; 
    z_mean_mat = z_mean_mat + pad_full;
end
z_pad6 = z_mat_flat(PadPlane.pad6.full);
z_pad6 = [z_pad6(PadPlane.pad6.pos(4):end,:);z_pad6(1:PadPlane.pad6.pos(4)-1,:)];
z_mean_mat = z_mean_mat/6;
z_mean_mat(z_mean_mat==0) = NaN;

figure
mesh(reshape(X(PadPlane.pad1.full),[],32),...
    reshape(Y(PadPlane.pad1.full),[],32),z_mean_mat)
xlabel('X [$mm$]'),ylabel('Y [$mm$]'),zlabel('Pad profile ($\mu m$)')
title('Average Pad profile')
% view(2)
% axis equal
colorbar
grid on

% figure
% mesh(reshape(X(PadPlane.pad6.full),[],32),...
%     reshape(Y(PadPlane.pad6.full),[],32),reshape(z_mat_flat(PadPlane.pad6.full),[],32))

% hold on
% plot(theta_mat(:,1),z_mat_flat(:,1)+30)
% plot(theta_mat(:,1),z_mat_flat(:,16)+30)
% plot(theta_mat(:,1),z_mat_flat(:,end)+30)
% hold off
% groove_depth = mean(z_mat_flat(isGroove),"all");
% fprintf('Mean groove depth: %.2f\n',groove_depth)
% figure
% subplot(1,2,1)
% mesh(X,Y,Z_groove);
% colorbar
% axis equal
% title('Groove profile and depth')
% xlabel('x')
% ylabel('y')
% view(2)
% 
% subplot(1,2,2)
% mesh(X,Y,Z_non_groove);
% colorbar
% axis equal
% title('Non-Grooved profile and height')
% xlabel('x')
% ylabel('y')
% view(2)

